/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.svn;

import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.ognl.ExpandoList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SvnSymbolicHelper {
    private static final Map TYPES = new LinkedHashMap();
    private final MyExpandoList trunks = new MyExpandoList();
    private final MyExpandoList branches = new MyExpandoList();
    private final MyExpandoList tags = new MyExpandoList();
    private String type = "none";

    private static SvnSymbolicRuleType makeEmptyRule() {
        return SvnSymbolicRuleType.Factory.newInstance();
    }

    private static SvnSymbolicRuleType makeRule(String regex, String name, String logical) {
        SvnSymbolicRuleType trunk = SvnSymbolicHelper.makeEmptyRule();
        trunk.setRegex(regex);
        trunk.setName(name);
        trunk.setLogical(logical);
        return trunk;
    }

    private static List[] makeType1() {
        LinkedList<SvnSymbolicRuleType> trunks = new LinkedList<SvnSymbolicRuleType>();
        trunks.add(SvnSymbolicHelper.makeRule("trunk(/|$)", "trunk", ""));
        LinkedList<SvnSymbolicRuleType> branches = new LinkedList<SvnSymbolicRuleType>();
        branches.add(SvnSymbolicHelper.makeRule("branches/([^/]+)", "${1}", ""));
        LinkedList<SvnSymbolicRuleType> tags = new LinkedList<SvnSymbolicRuleType>();
        tags.add(SvnSymbolicHelper.makeRule("tags/([^/]+)", "${1}", ""));
        return new List[]{trunks, branches, tags};
    }

    private static List[] makeType2() {
        LinkedList<SvnSymbolicRuleType> trunks = new LinkedList<SvnSymbolicRuleType>();
        trunks.add(SvnSymbolicHelper.makeRule("([^/]+)/trunk(/|$)", "trunk", "${1}"));
        LinkedList<SvnSymbolicRuleType> branches = new LinkedList<SvnSymbolicRuleType>();
        branches.add(SvnSymbolicHelper.makeRule("([^/]+)/branches/([^/]+)", "${1}-${2}", "${1}"));
        LinkedList<SvnSymbolicRuleType> tags = new LinkedList<SvnSymbolicRuleType>();
        tags.add(SvnSymbolicHelper.makeRule("([^/]+)/tags/([^/]+)", "${1}-${2}", "${1}"));
        return new List[]{trunks, branches, tags};
    }

    public void setupType1() {
        this.trunks.clear();
        this.type = "type1";
        List[] proto = SvnSymbolicHelper.makeType1();
        this.trunks.addAll((Collection)proto[0]);
        this.branches.addAll((Collection)proto[1]);
        this.tags.addAll((Collection)proto[2]);
    }

    public Map getTypes() {
        return TYPES;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeDescription() {
        return (String)TYPES.get(this.type);
    }

    public List getTrunk() {
        return this.trunks;
    }

    public List getBranch() {
        return this.branches;
    }

    public List getTag() {
        return this.tags;
    }

    public SvnSymbolicType toXmlBean() {
        SvnSymbolicType obj = SvnSymbolicType.Factory.newInstance();
        this.setup();
        obj.setTrunkArray(SvnSymbolicHelper.toRuleArray(this.trunks));
        obj.setBranchArray(SvnSymbolicHelper.toRuleArray(this.branches));
        obj.setTagArray(SvnSymbolicHelper.toRuleArray(this.tags));
        return obj;
    }

    public void setup(SvnRepType svn) {
        this.trunks.clear();
        this.branches.clear();
        this.tags.clear();
        if (svn.isSetSymbolic()) {
            SvnSymbolicType symbolic = svn.getSymbolic();
            SvnSymbolicHelper.cloneRules(this.trunks, symbolic.getTrunkArray());
            SvnSymbolicHelper.cloneRules(this.branches, symbolic.getBranchArray());
            SvnSymbolicHelper.cloneRules(this.tags, symbolic.getTagArray());
        }
        this.setup();
    }

    private static void cloneRules(List dest, SvnSymbolicRuleType[] tr) {
        for (int i2 = 0; i2 < tr.length; ++i2) {
            SvnSymbolicRuleType trunk = tr[i2];
            dest.add(trunk.copy());
        }
    }

    public void setup() {
        this.trunks.removeNulls();
        this.branches.removeNulls();
        this.tags.removeNulls();
        this.type = this.trunks.isEmpty() && this.branches.isEmpty() && this.tags.isEmpty() ? "none" : (this.isSame(SvnSymbolicHelper.makeType1()) ? "type1" : (this.isSame(SvnSymbolicHelper.makeType2()) ? "type2" : "custom"));
    }

    private boolean isSame(List[] proto) {
        return SvnSymbolicHelper.areRuleListsSame(this.trunks.getDelegate(), proto[0]) && SvnSymbolicHelper.areRuleListsSame(this.branches.getDelegate(), proto[1]) && SvnSymbolicHelper.areRuleListsSame(this.tags.getDelegate(), proto[2]);
    }

    private static boolean areRuleListsSame(List a2, List b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        ListIterator e1 = a2.listIterator();
        ListIterator e2 = b2.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            SvnSymbolicRuleType o1 = (SvnSymbolicRuleType)e1.next();
            SvnSymbolicRuleType o2 = (SvnSymbolicRuleType)e2.next();
            if (o1 != null ? SvnSymbolicHelper.equals(o1, o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private static boolean equals(SvnSymbolicRuleType o1, SvnSymbolicRuleType o2) {
        return StringUtil.equal(o1.getRegex(), o2.getRegex()) && StringUtil.equal(o1.getName(), o2.getName()) && StringUtil.equal(o1.getLogical(), o2.getLogical());
    }

    private static SvnSymbolicRuleType[] toRuleArray(List l) {
        return l.toArray(new SvnSymbolicRuleType[l.size()]);
    }

    static {
        TYPES.put("type1", "/trunk/..., /branches/NAME/..., /tags/NAME/...");
        TYPES.put("type2", "/project/trunk/..., /project/branches/NAME/..., /project/tags/NAME/...");
        TYPES.put("custom", "Custom");
        TYPES.put("none", "None");
    }

    static class MyExpandoList
    extends ExpandoList {
        MyExpandoList() {
        }

        protected Object justInTimeCreate(int index) {
            return SvnSymbolicHelper.makeEmptyRule();
        }
    }
}

