/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUserAction
extends BaseAdminAction {
    protected FEUser user = new FEUser();
    private List<String> userGroups;
    public static final int MIN_PASSWORD_LENGTH = 4;

    public Map getAuthTypes() {
        SecurityType sec = AppConfig.getsConfig().getConfig().getSecurity();
        LinkedHashMap<Integer, String> names = new LinkedHashMap<Integer, String>(FEUser.AUTH_NAMES);
        if (!sec.isSetLdap()) {
            names.remove(2);
        }
        if (!sec.isSetHostAuth()) {
            names.remove(3);
        }
        return names;
    }

    public FEUser getUser() {
        return this.user;
    }

    public List<String> getUserGroups() {
        if (this.userGroups == null) {
            if (this.user != null && !StringUtil.nullOrEmpty(this.user.getUsername())) {
                UserManager um = BaseUserAction.getUserManager();
                try {
                    this.userGroups = um.getGroupsForUser(this.user.getUsername());
                }
                catch (DbException e2) {
                    Logs.APP_LOG.warn((Object)"Problem getting group list", (Throwable)e2);
                    this.userGroups = Collections.emptyList();
                }
            } else {
                this.userGroups = Collections.emptyList();
            }
        }
        return this.userGroups;
    }

    protected void checkPassword(String password1, String password2) {
        if ("".equals(password1)) {
            this.addFieldError("password1", "Please enter a password");
            return;
        }
        if (!password1.equals(password2)) {
            this.addFieldError("password2", "Passwords don't match.");
        }
        if (password1.length() < 4) {
            this.addFieldError("password1", "Passwords must be at least 4 characters.");
        }
    }

    protected FEUser loadUser(String uname) {
        try {
            UserManager um = BaseUserAction.getUserManager();
            if (!um.userExists(uname)) {
                this.addActionError("No such user");
                return null;
            }
            return um.getUser(uname);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"error getting user", (Throwable)e2);
            this.addActionError("Internal DB problem (see logs)");
            return null;
        }
    }
}

