/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAdminAction
extends BaseAdminAction {
    private List<GroupData> groupData;

    public List<GroupData> getGroupDataList() {
        if (this.groupData == null) {
            this.groupData = new LinkedList<GroupData>();
            for (GroupInfo info : this.getGroupInfos()) {
                GroupData g2 = new GroupData(info);
                this.groupData.add(g2);
            }
        }
        return this.groupData;
    }

    public class GroupData {
        private final GroupInfo info;
        private Integer numUsers;

        public GroupData(GroupInfo info) {
            this.info = info;
        }

        public GroupInfo getInfo() {
            return this.info;
        }

        public String getTypes() {
            ArrayList<String> types = new ArrayList<String>();
            if (this.info.isBuiltin()) {
                types.add("built-in");
            }
            if (this.info.isFromExternalSource()) {
                types.add(this.info.getExternalSource());
            }
            return StringUtil.join(types, ", ");
        }

        public int getNumUsers() {
            if (this.numUsers == null) {
                try {
                    this.numUsers = GroupAdminAction.getUserManager().getUsersInGroup(this.info.getName()).size();
                }
                catch (DbException e2) {
                    Logs.APP_LOG.warn((Object)"problem counting users in group", (Throwable)e2);
                    this.numUsers = 0;
                }
            }
            return this.numUsers;
        }
    }
}

