/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAction;
import com.cenqua.fisheye.web.admin.actions.user.UserAddAction;

public class UserRenameAction
extends BaseUserAction {
    private String uname;
    private String newname;

    public String getNewname() {
        return this.newname;
    }

    public void setNewname(String newname) {
        this.newname = newname;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public String doDefault() throws Exception {
        this.newname = this.uname;
        this.user = this.loadUser(this.uname);
        return "success";
    }

    public String execute() throws Exception {
        UserManager um = UserRenameAction.getUserManager();
        um.renameUser(this.uname, this.newname);
        if (AppConfig.isCrucible()) {
            this.renameCruUser();
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameCruUser() {
        TxHelper txHelper = new TxHelper();
        try {
            txHelper.beginTx();
            CrucibleUserManager um = new CrucibleUserManager();
            um.renameUser(this.uname, this.newname);
            txHelper.commitTx();
        }
        finally {
            txHelper.rollbackTxIfNotCommited();
        }
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        UserManager um = UserRenameAction.getUserManager();
        try {
            if (this.newname.equals(this.uname)) {
                this.addFieldError("newname", "New username must be different from existing name");
                return;
            }
            FEUser existingUser = um.getUser(this.newname);
            if (existingUser != null) {
                this.addFieldError("newname", "This username is already in use");
            }
            if (!UserAddAction.USERNAME_PATTERN.matcher(this.newname).matches()) {
                this.addFieldError("newname", "Username can only contain alphanumeric, underscore, at ('@'), dot or dash");
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem changing user", (Throwable)e2);
            this.addActionError("Internal problem adding user (check logs)");
        }
    }
}

