/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.web.DirectorySorter;
import com.cenqua.fisheye.web.RepositoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class DirTree {
    private static final long MAX_TIME_SPENT_RECURSING = 10000L;
    private static final int MAX_SINGLE_DIR_DEPTH = 6;
    private final RepositoryExplorer mRepExplorer;
    public final RevisionCache mCrep;
    private int mEmptyDirCount = 0;
    private boolean mHideEmptyDirs;
    private boolean mHideEmptyDirsDisabled = false;
    private int mHiddenDirCount = 0;
    private final boolean mHideHiddenDirs;
    private final List mHideDirPatterns;
    private List mSubdirs;
    private boolean mAborted = false;

    public DirTree(RepositoryExplorer rep) throws DbException {
        long t0 = System.currentTimeMillis();
        this.mRepExplorer = rep;
        this.mHideEmptyDirs = rep.mUP.getPreference("hideEmptyDirectories").equals("Y");
        this.mHideHiddenDirs = rep.mUP.getPreference("hideHiddenDirectories").equals("Y");
        this.mHideDirPatterns = rep.mEngine.getCfg().getHideDirectoryPatterns();
        WaybackSpec mWB = rep.mWB;
        this.mCrep = rep.mCRep;
        DirTreeCache dtcache = rep.mEngine.getDirTreeCache();
        RepositoryStatus us = rep.mEngine.getStatus();
        if (us != null && !us.isDoneFullSlurp()) {
            this.mHideEmptyDirsDisabled = true;
            this.mHideEmptyDirs = false;
        }
        final Path path = this.mRepExplorer.getLocalPath();
        dtcache.calculateWith(mWB, new DirTreeCache.Visitor(){

            public void visit(DirTreeCache.Context calc) throws DbException {
                DirNode root = new DirNode(path, false, calc.isEmptyOfFiles(path), 0);
                DirTree.this.mSubdirs = DirTree.this.computeSubDirs(root, false, calc);
                DirTree.this.recurseNode(DirTree.this.mSubdirs, calc);
            }
        });
        if (Logs.PERF_LOG.isInfoEnabled()) {
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.info((Object)("built dirtree data for /" + path + " in " + (t1 - t0) + "ms"));
        }
    }

    public Path getPath() {
        return this.mRepExplorer.getLocalPath();
    }

    public List getSubDirs() {
        return this.mSubdirs;
    }

    public boolean isHideEmptyDirsDisabled() {
        return this.mHideEmptyDirsDisabled;
    }

    public boolean isHideHiddenDirs() {
        return this.mHideHiddenDirs;
    }

    public boolean isHideEmptyDirs() {
        return this.mHideEmptyDirs;
    }

    public int getHiddenDirCount() {
        return this.mHiddenDirCount;
    }

    public int getEmptyDirCount() {
        return this.mEmptyDirCount;
    }

    public boolean isAborted() {
        return this.mAborted;
    }

    private void recurseNode(List startNodes, DirTreeCache.Context calc) throws DbException {
        LinkedList<DirNode> leftToProcess = new LinkedList<DirNode>();
        leftToProcess.addAll(startNodes);
        long t0 = System.currentTimeMillis();
        boolean timeExceeded = false;
        while (!leftToProcess.isEmpty()) {
            DirNode node = (DirNode)leftToProcess.removeFirst();
            int depth = node.getDepth();
            long t1 = System.currentTimeMillis();
            boolean bl = timeExceeded = t1 - t0 > 10000L;
            if (timeExceeded && depth > 0) break;
            List children = this.computeSubDirs(node, true, calc);
            node.hasSubdirs = children.size() > 0;
            boolean singleSubdir = children.size() == 1 && depth <= 6;
            if (!singleSubdir) continue;
            node.lonelyChild = (DirNode)children.get(0);
            leftToProcess.add(node.lonelyChild);
        }
        if (timeExceeded) {
            Logs.PERF_LOG.info((Object)("time to recurse /" + this.getPath() + " exceeded"));
        }
        if (!leftToProcess.isEmpty()) {
            this.mAborted = true;
        }
    }

    private List computeSubDirs(DirNode parentNode, boolean breakIfMany, DirTreeCache.Context calc) throws DbException {
        long t0 = System.currentTimeMillis();
        Path path = parentNode.getPath();
        LinkedList<DirNode> results = new LinkedList<DirNode>();
        List subdirs = Arrays.asList(this.mCrep.listDirs(path));
        subdirs = DirectorySorter.sortByPerference(subdirs, this.mCrep, this.mRepExplorer.mUP);
        long t1 = System.currentTimeMillis();
        int depth = parentNode.getDepth() + 1;
        for (int i2 = 0; i2 < subdirs.size(); ++i2) {
            Path subdir = (Path)subdirs.get(i2);
            boolean hidden = this.isDirHidden(subdir);
            boolean empty = parentNode.isEmptyOfFiles() || calc.isEmptyOfFiles(subdir);
            DirNode node = new DirNode(subdir, hidden, empty, depth);
            boolean skip = false;
            if (hidden) {
                ++this.mHiddenDirCount;
                if (this.isHideHiddenDirs()) {
                    skip = true;
                }
            }
            if (empty) {
                ++this.mEmptyDirCount;
                if (this.isHideEmptyDirs()) {
                    skip = true;
                }
            }
            if (skip) continue;
            results.add(node);
            if (breakIfMany && results.size() > 1) break;
        }
        if (Logs.PERF_LOG.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            Logs.PERF_LOG.debug((Object)("computeSubDirs for /" + path + " (" + results.size() + "/" + subdirs.size() + " subdirs) in " + (t2 - t0) + "ms (" + (t1 - t0) + "ms for list-and-sort)"));
        }
        return results;
    }

    private boolean isDirHidden(Path subdir) {
        if (this.mHideDirPatterns.isEmpty()) {
            return false;
        }
        for (AntGlob glob : this.mHideDirPatterns) {
            if (!glob.matches(subdir.toString())) continue;
            return true;
        }
        return false;
    }

    public static class DirNode {
        private final Path mPath;
        private final boolean mHidden;
        private final boolean mEmpty;
        private final int mDepth;
        private DirNode lonelyChild;
        private boolean hasSubdirs;

        public DirNode(Path path, boolean hidden, boolean empty, int depth) {
            this.mPath = path;
            this.mHidden = hidden;
            this.mEmpty = empty;
            this.mDepth = depth;
        }

        public Path getPath() {
            return this.mPath;
        }

        public boolean isHidden() {
            return this.mHidden;
        }

        public boolean isEmptyOfFiles() {
            return this.mEmpty;
        }

        public int getDepth() {
            return this.mDepth;
        }

        public List getSingeDirSubTreeList() {
            LinkedList<DirNode> result = new LinkedList<DirNode>();
            for (DirNode current = this.getLonleyChild(); current != null; current = current.getLonleyChild()) {
                result.add(current);
            }
            return result;
        }

        public DirNode getLastLonleySubdir() {
            DirNode result = this;
            while (result.getLonleyChild() != null) {
                result = result.getLonleyChild();
            }
            return result;
        }

        public DirNode getLonleyChild() {
            return this.lonelyChild;
        }

        public boolean isLastLonleySubdirEmpty() {
            return !this.getLastLonleySubdir().hasSubdirs;
        }

        public String getStyleSuffix() {
            String s = "";
            if (this.isHidden()) {
                s = s + "Hidden";
            }
            if (this.isEmptyOfFiles()) {
                s = s + "Empty";
            }
            return s.equals("") ? "Plain" : s;
        }

        public String toString() {
            return "DirNode[" + this.mPath + "]";
        }
    }
}

