/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.atlassian.fisheye.plugin.webresource.FisheyeWebResourceIntegration;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UpfrontFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            if (Logs.PERF_LOG.isDebugEnabled()) {
                UpfrontFilter.logRequest("start request", request);
            }
            FisheyeWebResourceIntegration.setContextPath(request.getContextPath());
            request.setAttribute("siteurl", (Object)UpfrontFilter.getBaseUrl(request));
            request.setAttribute("TS_BEGIN_PROCESSING", (Object)System.currentTimeMillis());
            this.fixupCharset(request);
            this.recordOriginalUrl(request);
            chain.doFilter(req, res);
            if (Logs.PERF_LOG.isDebugEnabled()) {
                UpfrontFilter.logRequest("end request", request);
            }
        }
    }

    private static void logRequest(String msg, HttpServletRequest request) {
        String uri = request.getRequestURI();
        String qs = request.getQueryString();
        HttpSession session = request.getSession(false);
        Logs.PERF_LOG.debug((Object)(msg + " " + uri + (qs == null ? "" : "?" + qs) + (session != null ? " sessionid=" + session.getId() : " nosession")));
    }

    private void recordOriginalUrl(HttpServletRequest request) {
        if (request.getAttribute("fisheye.forward.context_path") == null) {
            request.setAttribute("fisheye.forward.context_path", (Object)request.getContextPath());
        }
        if (request.getAttribute("fisheye.forward.request_uri") == null) {
            request.setAttribute("fisheye.forward.request_uri", (Object)request.getRequestURI());
        }
        if (request.getAttribute("fisheye.forward.query_string") == null) {
            request.setAttribute("fisheye.forward.query_string", (Object)request.getQueryString());
        }
    }

    private static String getBaseUrl(HttpServletRequest req) {
        String ctx;
        StringBuffer url = new StringBuffer(48);
        String scheme = req.getScheme();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        int port = req.getServerPort();
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        if (!(ctx = req.getContextPath()).startsWith("/")) {
            url.append("/");
        }
        url.append(ctx);
        char lastc = url.charAt(url.length() - 1);
        if (lastc != '/') {
            url.append("/");
        }
        return url.toString();
    }

    private void fixupCharset(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request.getMethod().equals("POST") && request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

