/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.obfuscate.idbk4ui8v.locking;

import com.cenqua.obfuscate.idbk4ui8v.locking.FileLockException;
import com.cenqua.obfuscate.idbk4ui8v.locking.FileLockedExternallyException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;

public class ChannelLock {
    FileLock a;

    public ChannelLock(RandomAccessFile randomAccessFile, long l, long l2, boolean bl, boolean bl2) throws IOException {
        try {
            FileChannel fileChannel = randomAccessFile.getChannel();
            this.a = bl ? fileChannel.tryLock(l, l2, !bl2) : fileChannel.lock(l, l2, !bl2);
        }
        catch (NonReadableChannelException nonReadableChannelException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - not readable");
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - not writable");
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file in " + (bl2 ? "exclusive" : "shared") + " mode - already open internally");
        }
        catch (IllegalStateException illegalStateException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - illegal state: " + illegalStateException.getMessage());
        }
        catch (FileLockInterruptionException fileLockInterruptionException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - locking was interrupted");
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - asynchronous close");
        }
        catch (ClosedChannelException closedChannelException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - already closed");
        }
        catch (IOException iOException) {
            throw new FileLockException(bl, bl2, l, l2, "Cannot lock file - IOException " + iOException.getMessage());
        }
        if (this.a == null) {
            throw new FileLockedExternallyException(bl, bl2, l, l2, "Cannot lock file in " + (bl2 ? "exclusive" : "shared") + " mode - already in use");
        }
    }

    public void release() {
        try {
            if (this.a != null) {
                this.a.release();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

