/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.obfuscate.idbk4ui8v.sort;

import com.cenqua.obfuscate.idbk4ui8v.sort.DiskBasedMergeSorterTempFileManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class SimpleDiskBasedMergeSorterTempFileManager
extends DiskBasedMergeSorterTempFileManager {
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String DEFAULT_FILE_NAME_PREFIX = "InfinityDBSortMergeTemp";
    private File a;
    private String b;
    private File c;
    private RandomAccessFile d;
    private boolean e;

    public SimpleDiskBasedMergeSorterTempFileManager(File file) throws IOException {
        this(file, "", true);
    }

    public SimpleDiskBasedMergeSorterTempFileManager(File file, String string) throws IOException {
        this(file, string, true);
    }

    public SimpleDiskBasedMergeSorterTempFileManager(File file, String string, boolean bl) {
        this.a = file;
        this.b = string;
        if (file == null) {
            throw new IllegalArgumentException("tempDir is null");
        }
        if (string == null) {
            string = "";
        }
        this.e = bl;
    }

    public void createTemporaryFileSpaceAndLock() throws IOException {
        if (this.a.isFile()) {
            throw new RuntimeException("tempDir exists and is a file: " + this.a);
        }
        if (!this.a.isDirectory()) {
            this.a.mkdirs();
        }
        this.c = new File(this.a, this.b + DEFAULT_FILE_NAME_PREFIX + LOCK_FILE_NAME);
        this.d = null;
        try {
            this.d = new RandomAccessFile(this.c, "rws");
            FileChannel fileChannel = this.d.getChannel();
            if (this.e) {
                FileLock fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    this.a((Exception)null);
                }
            } else {
                fileChannel.lock();
            }
            this.d.writeChars("This is an InfinityDB lock file for the temporary data files used during sorting.\r\nFor this sort space, the files all have prefix " + this.b + "\r\n" + "Deleting or modifying any of " + "the temporary files while this " + "lockfile is locked will\r\n" + "cause the sort to fail in undefined " + "ways, such as by losing or corrupting data.\r\n" + "The individual temporary files are not locked.\r\n");
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.a(overlappingFileLockException);
        }
        this.a();
    }

    private void a(Exception exception) throws IOException {
        IOException iOException = new IOException("The lockfile " + this.c + " is already locked by another Thread or process, " + "so another InfinityDB DiskFileSortMerge must already " + "be in progress in directory " + this.a);
        if (exception != null) {
            iOException.initCause(exception);
        }
        if (this.d != null) {
            this.d.close();
        }
    }

    public File generateTemporaryFile(int n, int n2) {
        return new File(this.a, this.a(n) + "_" + SimpleDiskBasedMergeSorterTempFileManager.a(n2, 6));
    }

    private String a(int n) {
        String string = this.b + DEFAULT_FILE_NAME_PREFIX + '_' + SimpleDiskBasedMergeSorterTempFileManager.a(n, 6);
        return string;
    }

    public void deleteTemporaryFilesForPass(int n) throws IOException {
        String string = this.a(n).toLowerCase();
        File[] fileArray = this.a.listFiles();
        for (int j = 0; j < fileArray.length; ++j) {
            String string2 = fileArray[j].getName().toLowerCase();
            if (!this.a(string2) || !string2.startsWith(string)) continue;
            fileArray[j].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllTemporaryFilesAndUnlock() throws IOException {
        this.a();
        try {
            if (this.d != null) {
                this.d.close();
            }
        }
        finally {
            this.c.delete();
        }
    }

    private void a() {
        File[] fileArray = this.a.listFiles();
        for (int j = 0; j < fileArray.length; ++j) {
            if (!this.a(fileArray[j].getName())) continue;
            fileArray[j].delete();
        }
    }

    private boolean a(String string) {
        String string2 = this.b + DEFAULT_FILE_NAME_PREFIX;
        if (!string.toLowerCase().startsWith(string2.toLowerCase())) {
            return false;
        }
        int n = this.b.length();
        if (this.a(string, n++) != '_') {
            return false;
        }
        if (!Character.isDigit(this.a(string, n++))) {
            return false;
        }
        if (!Character.isDigit(this.a(string, n++))) {
            return false;
        }
        while (Character.isDigit(this.a(string, n))) {
            ++n;
        }
        if (this.a(string, n++) != '_') {
            return false;
        }
        if (!Character.isDigit(this.a(string, n++))) {
            return false;
        }
        if (!Character.isDigit(this.a(string, n++))) {
            return false;
        }
        while (Character.isDigit(this.a(string, n))) {
            ++n;
        }
        return string.length() == n;
    }

    private char a(String string, int n) {
        char c2 = n >= string.length() ? (char)'\u0000' : Character.toLowerCase(string.charAt(n));
        return c2;
    }

    private static String a(int n, int n2) {
        String string = Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < n2 - string.length(); ++j) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

